import java.util.*;                 // 리스트 및 컬렉션 관련 클래스
import java.util.stream.Collectors;  // Stream 결과를 리스트로 변환하는 Collectors 클래스

// Product 클래스: 제품 정보를 저장하는 클래스
class Product {
    int id;         // 제품 ID
    String name;  // 제품 이름
    int price;      // 제품 가격

    public Product(int id, String name, int price) {
        super();
        this.id = id;
        this.name = name;
        this.price = price;
    }
}

public class StreamTest {
    public static void main(String[] args) {
        List<Product> list = new ArrayList<Product>();

        // 리스트에 제품 추가
        list.add(new Product(1, "NoteBook", 100));
        list.add(new Product(2, "TV", 320));
        list.add(new Product(3, "Washing Machine", 250));
        list.add(new Product(4, "Air Conditioner", 500));

        // 스트림을 이용한 필터링 및 변환
        List<String> result = list.stream()
                .filter(p -> p.price > 300)   // 가격이 300 이상인 제품만 필터링
                .map(p -> p.name)         // 필터링된 제품의 이름만 추출
                .collect(Collectors.toList());  // 결과를 리스트로 변환

        System.out.println(result);
    }
}
