import java.util.*;
import java.util.stream.Collectors;  // 스트림 결과를 리스트로 변환하는 Collectors 클래스

public class StreamExample2 {
    public static void main(String[] args) {
        List<String> words = Arrays.asList("Java", "Stream", "Library");
        System.out.println("입력 데이터 = " + words);  // 원본 리스트 출력

        // 스트림을 이용한 문자열 길이 변환
        List<Integer> result = words.stream()  // 리스트를 스트림으로 변환
                .map(String::length)            // 각 문자열의 길이를 계산하여 변환
                .collect(Collectors.toList());      // 결과를 리스트로 변환

        System.out.println("실행 결과 = " + result);
    }
}
