import java.util.*;
import java.util.stream.Collectors;

public class StreamExample1 {
    public static void main(String[] args) {
        List<Integer> numbers = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8);
        System.out.println("입력 데이터 = " + numbers);  // 원본 리스트 출력

        // 스트림을 이용한 필터링 및 변환
        List<Integer> result = numbers.stream()  // 리스트를 스트림으로 변환
                .filter(n -> {  // 필터링: 짝수만 남김
                    return n % 2 == 0;
                })
                .map(n -> {  // 변환: 짝수를 제곱
                    return n * n;
                })
                .collect(Collectors.toList());  // 결과를 리스트로 변환

        System.out.println("실행 결과 = " + result);
    }
}