import java.util.*;

public class CarDemo {
    public static List<Car> selectCars(List<Car> inventory, CarPredicate p) {
        List<Car> result = new ArrayList<>();
        for (Car car : inventory) {
            if (p.test(car)) {
                result.add(car);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        List<Car> carList = Arrays.asList(
            new Car(1, "BENZ S", "BLACK", 11000),
            new Car(2, "BMW 9", "BLUE", 8000),
            new Car(3, "KIA 9", "WHITE", 7000),
            new Car(4, "AUDI", "WHITE", 4500)
        );

        List<Car> whiteCheapCars = selectCars(carList, 
            (Car car) -> "WHITE".equals(car.getColor()) && car.getPrice() <= 5000
        );

        System.out.println("검색 결과: " + whiteCheapCars);
    }
}
