package ThreadPriorityTest;
class PriorityThread extends Thread {
    public PriorityThread(String name) {
        super(name);
    }
    @Override
    public void run() {
        for (int i = 0; i < 5; i++) {
            System.out.println(getName() + " 실행 (우선순위: " + getPriority() + ")");
            try {
                Thread.sleep(100);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

public class ThreadPriorityTest {
    public static void main(String[] args) {
        PriorityThread thread1 = new PriorityThread("스레드-1 (낮은 우선순위)");
        PriorityThread thread2 = new PriorityThread("스레드-2 (기본 우선순위)");
        PriorityThread thread3 = new PriorityThread("스레드-3 (높은 우선순위)");

        thread1.setPriority(Thread.MIN_PRIORITY);
        thread2.setPriority(Thread.NORM_PRIORITY);
        thread3.setPriority(Thread.MAX_PRIORITY);

        thread1.start();
        thread2.start();
        thread3.start();
    }
}
