package CountDownInterrupt;
import javax.swing.*;
import java.awt.*;

public class CountDownInterrupt extends JFrame {
    private JLabel label;
    Thread t;

    class Counter extends Thread {
        public void run() {
            for (int i = 0; i <= 10; i++) {
                try {
                    Thread.sleep(1000);
                } catch (InterruptedException e) {
                    return; // 인터럽트 발생 시 스레드 종료
                }
                label.setText(i + "");
            }
        }
    }

    public CountDownInterrupt() {
        setTitle("카운트다운 중지");
        setSize(400, 150);
        getContentPane().setLayout(null);

        label = new JLabel("0");
        label.setBounds(0, 0, 384, 111);
        label.setFont(new Font("Serif", Font.BOLD, 100));
        getContentPane().add(label);

        JButton btnNewButton = new JButton("카운터 중지");
        btnNewButton.setBounds(247, 25, 125, 23);
        // 버튼 클릭 시 인터럽트 발생
        btnNewButton.addActionListener(e -> t.interrupt());
        getContentPane().add(btnNewButton);

        setVisible(true);
        t = new Counter();
        t.start();
    }

    public static void main(String[] args) {
        new CountDownInterrupt();
    }
}
