package ImageFileCopy;
import java.io.*;

public class ImageFileCopy {
    public static void main(String[] args) {
        String sourceImage = "source.jpg";
        String destinationImage = "copy.jpg";
        try (FileInputStream in = new FileInputStream(sourceImage);
             FileOutputStream out = new FileOutputStream(destinationImage)) {
            byte[] buffer = new byte[1024]; 
            int bytesRead;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            System.out.println("이미지 파일 복사가 완료되었습니다.");
        } catch (IOException e) {
            System.out.println("입출력 오류 발생: " + e.getMessage());
        }
    }
}
