package UnzipTest;
import java.io.*;
import java.util.*;
import java.util.zip.*;

public class UnzipTest {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        System.out.println("압축 파일 이름을 입력하시오: ");
        String inname = sc.next();
        System.out.println("원본 파일 이름을 입력하시오: ");
        String outname = sc.next();
        
        try (ZipInputStream inStream = new ZipInputStream(new FileInputStream(inname));
             OutputStream outStream = new FileOutputStream(outname)) {
            byte[] buffer = new byte[1024];
            int read;
            if (inStream.getNextEntry() != null) {
                while ((read = inStream.read(buffer)) > 0) {
                    outStream.write(buffer, 0, read);
                }
            }
        } catch (IOException e) {
            System.out.println("오류 발생: " + e.getMessage());
        } finally {
            sc.close();
        }
    }
}
