package FileProcessor;
import java.io.*;
import java.util.Scanner;

// 소스 파일이 UTF-8로 저장되어 있어야 합니다.
public class FileProcessor {
    public static void main(String args[]) throws IOException {
        File directoryPath = new File("D:/src");
        File[] filesList = directoryPath.listFiles();
        
        if (filesList == null) {
            System.out.println("디렉터리에 파일이 없습니다.");
            return;
        }
        
        for (File file : filesList) {
            if (!file.getName().endsWith(".c") && !file.getName().endsWith(".txt")) continue;
            
            System.out.println("파일 이름: " + file.getName());
            StringBuilder sb = new StringBuilder();
            sb.append("#define _CRT_SECURE_NO_WARNINGS\n");
            
            try (Scanner sc = new Scanner(file)) {
                while (sc.hasNextLine()) {
                    sb.append(sc.nextLine()).append("\n");
                }
            } catch (IOException e) {
                System.out.println("오류: " + e.getMessage());
                continue;
            }
            
            String newFileName = file.getAbsolutePath() + "1.c";
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(newFileName))) {
                writer.write(sb.toString());
            }
        }
    }
}
