package ObjectStreamTest;
import java.io.*;
import java.util.*;

public class ObjectStreamTest {
    public static void main(String[] args) {
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("object.dat"))) {
            out.writeObject(new Date());
            System.out.println("객체가 성공적으로 파일에 저장되었습니다.");
        } catch (IOException e) {
            System.err.println("저장 오류: " + e.getMessage());
        }
        try (ObjectInputStream in = new ObjectInputStream(new FileInputStream("object.dat"))) {
            Date d = (Date) in.readObject();
            System.out.println("파일에서 읽은 객체: " + d);
        } catch (Exception e) {
            System.err.println("읽기 오류: " + e.getMessage());
        }
    }
}
