import java.util.*; // java.util 패키지의 모든 클래스를 임포트(HashMap 등 사용을 위해 필요)

public class WordFrequencyCounter {
    public static void main(String[] args) {
        String text = "apple banana apple cherry banana apple";

        // 단어와 빈도를 저장할 Map 생성(단어: String, 빈도: Integer)
        Map<String, Integer> wordCount = new HashMap<>();

        String[] words = text.split(" ");  // 텍스트를 공백 기준으로 단어 배열로 분리

        for (String word : words) {  // 각 단어의 빈도수를 계산
            // 기존 단어의 빈도수를 가져오고, 없으면 기본값 0을 설정한 뒤 1 증가
            wordCount.put(word, wordCount.getOrDefault(word, 0) + 1);
        }

        System.out.println("단어 빈도수: " + wordCount);
    }
}
