import java.util.*;

public class SetOperationsExample {
    public static void main(String[] args) {
        Set<String> set1 = new HashSet<>();  // 첫 번째 집합 생성
        set1.add("사과");
        set1.add("바나나");
        set1.add("체리");

        Set<String> set2 = new HashSet<>();  // 두 번째 집합 생성
        set2.add("바나나");
        set2.add("체리");
        set2.add("포도");

        // 합집합 계산
        Set<String> unionSet = new HashSet<>(set1);  // set1의 모든 요소를 unionSet에 복사
        unionSet.addAll(set2);  // set2의 모든 요소를 unionSet에 추가 (중복은 자동 제거)

        // 교집합 계산
        Set<String> intersectionSet = new HashSet<>(set1);  // set1의 모든 요소를 intersectionSet에 복사
        intersectionSet.retainAll(set2);  // set2와 공통된 요소만 intersectionSet에 남김

        System.out.println("첫 번째 집합: " + set1);
        System.out.println("두 번째 집합: " + set2);
        System.out.println("합집합: " + unionSet);  // 합집합 결과 출력
        System.out.println("교집합: " + intersectionSet);  // 교집합 결과 출력
    }
}
