// 제네릭 메소드를 이용한 배열 출력 프로그램
public class GenericMethodTest {
    // 제네릭 메소드: 다양한 타입의 배열을 출력할 수 있음
    public static <T> void printArray(T[] array) {
        for (T element : array) {  // 배열 요소를 하나씩 순회
            System.out.printf("%s ", element);  // 요소 출력
        }
        System.out.println();  // 줄바꿈
    }

    public static void main(String args[]) {
        Integer[] iArray = {10, 20, 30, 40, 50};     // 정수 배열
        Double[] dArray = {1.1, 1.2, 1.3, 1.4, 1.5};  // 실수 배열
        Character[] cArray = {'K', 'O', 'R', 'E', 'A'};  // 문자 배열

        // 제네릭 메소드를 사용하여 배열 출력
        printArray(iArray);  // 정수 배열 출력
        printArray(dArray);  // 실수 배열 출력
        printArray(cArray);  // 문자 배열 출력
    }
}
