import java.util.*; // 컬렉션 및 유틸리티 클래스 관련 패키지

// Student 클래스: 학생 정보를 저장하며, Comparable 인터페이스를 구현하여 정렬 가능하게 함
class Student implements Comparable<Student> {
    int number;   // 학생 번호
    String name;  // 학생 이름

    public Student(int number, String name) {
        this.number = number;
        this.name = name;
    }

    // 객체를 문자열로 변환할 때 호출되는 메소드(출력 시 이름만 반환)
    public String toString() {
        return name;
    }

    // 비교 메소드: Student 객체를 정렬할 기준을 정의(내림차순 정렬)
    public int compareTo(Student s) {
        return s.number - number;  // 학생 번호를 기준으로 내림차순 정렬
    }
}

public class SortTest {
    public static void main(String[] args) {
        Student array[] = {  // Student 객체 배열 생성
                new Student(2, "김철수"),
                new Student(3, "이철수"),
                new Student(1, "박철수"),
        };

        List<Student> list = Arrays.asList(array);  // 배열을 리스트로 변환

        // 기본 정렬: Student 클래스의 compareTo() 메소드를 기준으로 정렬(내림차순 정렬)
        Collections.sort(list);
        System.out.println("기본 정렬(학생 번호 내림차순): " + list);

        // 역순 정렬: 기본 정렬의 반대 방향으로 정렬
        Collections.sort(list, Collections.reverseOrder());
        System.out.println("역순 정렬(학생 번호 오름차순): " + list);
    }
}