import java.util.*;

// 학생 정보를 저장하는 Student 클래스
class Student {
    String name;  // 학생 이름
    int grade;     // 학생 학년
    String major;  // 학생 전공

    // Student 클래스의 생성자: 이름, 학년, 전공을 초기화
    public Student(String name, int grade, String major) {
        this.name = name;
        this.grade = grade;
        this.major = major;
    }

    // 객체 정보를 문자열로 변환하여 반환(toString 메소드 오버라이딩)
    @Override
    public String toString() {
        return "이름: " + name + ", 학년: " + grade + ", 전공: " + major;
    }
}

// 학생 디렉터리를 관리하는 클래스
public class StudentDirectory {
    public static void main(String[] args) {
        // 학생 정보를 저장할 HashMap 생성(키: 학번, 값: 학생 객체)
        Map<String, Student> studentDirectory = new HashMap<>();

        // 학생 정보 추가: 학번(key)와 Student 객체(value)로 구성
        studentDirectory.put("12345", new Student("Kim", 2, "Computer Science"));
        studentDirectory.put("67890", new Student("Park", 3, "Mathematics"));

        // 특정 학생의 정보 조회 및 출력
        String studentId = "12345";  // 조회할 학생 ID
        System.out.println("학생 ID " + studentId + "의 정보: " + studentDirectory.get(studentId));

        // 전체 학생 정보 출력(HashMap의 모든 요소 출력)
        System.out.println("전체 학생 정보: " + studentDirectory);
    }
}