// 제네릭 클래스로 2개의 타입 매개변수 K(Key), V(Value)를 사용
class Pair<K, V> {
    private K key;       // K 타입의 key 필드
    private V value;     // V 타입의 value 필드

    public Pair(K key, V value) { // key와 value를 초기화하는 생성자
        this.key = key;           // 전달받은 key 값을 필드에 저장
        this.value = value;       // 전달받은 value 값을 필드에 저장
    }
    public K getKey() {          // K 타입의 key 값을 반환하는 메소드
        return key;              // key 값을 반환
    }
    public V getValue() {        // V 타입의 value 값을 반환하는 메소드
        return value;            // value 값을 반환
    }
}

public class Test {
    public static void main(String[] args) {
        // Pair 객체 생성, K는 String, V는 Integer 타입
        Pair<String, Integer> pair = new Pair<>("Age", 30);
        System.out.println(pair.getKey() + ": " + pair.getValue()); // key와 value 값을 출력
    }
}