import java.util.Calendar;
import java.util.Date;

public class CalendarExample {
    public static void main(String[] args) {
        // 현재 날짜와 시간의 Calendar 객체 생성
        Calendar calendar = Calendar.getInstance();

        // 현재 날짜와 시간 정보 출력
        System.out.println("현재 시각: " + calendar.getTime());

        // 특정 날짜로 설정(2024년 8월 15일)
        calendar.set(2024, Calendar.AUGUST, 15);
        System.out.println("설정된 날짜: " + calendar.getTime());

        // 날짜 조작: 7일 추가
        calendar.add(Calendar.DAY_OF_MONTH, 7);
        System.out.println("7일 후: " + calendar.getTime());

        // 날짜 조작: 1개월 감소
        calendar.add(Calendar.MONTH, -1);
        System.out.println("1개월 전: " + calendar.getTime());

        // 필드 가져오기
        int year = calendar.get(Calendar.YEAR);
        int month = calendar.get(Calendar.MONTH) + 1;  // 0부터 시작하므로 +1
        int day = calendar.get(Calendar.DAY_OF_MONTH);
        System.out.println("현재 설정된 날짜: " + year + "년 " + month + "월 " + day + "일");

        // Calendar 객체를 Date 객체로 변환
        Date date = calendar.getTime();
        System.out.println("Date 객체: " + date);
    }
}