public class StringMethodsExample {
    public static void main(String[] args) {
        // 문자열 초기화
        String original = "  Hello, Java World!  ";

        // 특정 위치의 문자 추출
        char charAtPosition = original.charAt(7);
        System.out.println("7번째 위치의 문자: " + charAtPosition);  // 'J'

        // 문자열 비교
        boolean equals = original.trim().equals("Hello, Java World!");
        System.out.println("문자열 비교(공백 제거 후): " + equals);  // true

        boolean equalsIgnoreCase = original.trim().equalsIgnoreCase("hello, java world!");
        System.out.println("대소문자 무시 비교: " + equalsIgnoreCase);  // true

        // 문자열 검색
        int indexOfJava = original.indexOf("Java");
        System.out.println("\"Java\"의 위치: " + indexOfJava);  // 8

        // 공백 제거
        String trimmed = original.trim();
        System.out.println("공백 제거: \"" + trimmed + "\"");

        // 문자열 분리
        String[] words = trimmed.split(", ");
        System.out.println("쉼표와 공백을 기준으로 분리:");

        for (String word : words) {
            System.out.println(" - " + word);
        }
    }
}