class Person {
    private String name;
    private int age;

    public Person(String name, int age) {
        this.name = name;
        this.age = age;
    }
    // equals() 메소드 재정의
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null || getClass() != obj.getClass()) return false;

        Person person = (Person) obj;
        return age == person.age && name.equals(person.name);
    }
    // hashCode() 메소드도 함께 재정의해야 한다.
    @Override
    public int hashCode() {
        int result = name.hashCode();  // name과 age가 같으면 동일한 값을 반환
        result = 31 * result + age;
        return result;
    }
}


public class PersonTest {
    public static void main(String[] args) {
        Person person1 = new Person("Kim", 30);
        Person person2 = new Person("Kim", 30);
        System.out.println(person1.equals(person2));  // true
    }
}