//TIP 코드를 <b>실행</b>하려면 <shortcut actionId="Run"/>을(를) 누르거나
// 에디터 여백에 있는 <icon src="AllIcons.Actions.Execute"/> 아이콘을 클릭하세요.
void main() {
// get(int field): 지정된 달력 필드의 값을 가져온다.
    Calendar calendar = Calendar.getInstance();
    int year = calendar.get(Calendar.YEAR);
    int month = calendar.get(Calendar.MONTH);  // 0부터 시작(0=January)
    int day = calendar.get(Calendar.DAY_OF_MONTH);

// set(int field, int value): 지정된 달력 필드의 값을 설정한다.
    calendar.set(Calendar.YEAR, 2024);
    calendar.set(Calendar.MONTH, Calendar.AUGUST);  // 8월로 설정
    calendar.set(Calendar.DAY_OF_MONTH, 15);

// set(int year, int month, int date): 연, 월, 일 필드를 한꺼번에 설정한다.
    calendar.set(2024, Calendar.AUGUST, 15);

// add(int field, int amount): 지정된 시간 필드에 주어진 양을 더하거나 뺀다.
    calendar.add(Calendar.DAY_OF_MONTH, 7);  // 7일 후로 설정
    calendar.add(Calendar.MONTH, -1);  // 1개월 전으로 설정

// roll(int field, boolean up): 지정된 시간 필드를 증가(또는 감소)하지만 다른 필드에 영향을 미치지 않는다.
    calendar.roll(Calendar.DAY_OF_MONTH, true);  // 하루 증가

    Calendar anotherCalendar = Calendar.getInstance();
// before(Object when): 이 Calendar 객체의 시간이 지정된 시간보다 이전인지 여부를 반환한다.
    boolean isBefore = calendar.before(anotherCalendar);

// after(Object when): 이 Calendar 객체의 시간이 지정된 시간보다 이후인지 여부를 반환한다.
    boolean isAfter = calendar.after(anotherCalendar);

// getTime(): Calendar 객체를 Date 객체로 반환한다.
    Date date = calendar.getTime();

// setTime(Date date): 주어진 Date 객체로 Calendar를 설정한다.
    calendar.setTime(new Date());

// getTimeInMillis(): Calendar 객체의 시간을 밀리초 단위로 반환한다.
    long millis = calendar.getTimeInMillis();
}
