import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class FollowMouseApp extends JFrame {
    // MyPanel 클래스: 패널 정의
    private class MyPanel extends JPanel implements MouseMotionListener {
        private int x = -50, y = -50;  // 공의 초기 위치

        public MyPanel() {
            addMouseMotionListener(this);  // 마우스 이벤트 리스너 추가
        }
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(Color.BLUE);
            g.fillOval(x - 25, y - 25, 50, 50);  // 마우스 위치 기준 원 그리기
        }
        @Override
        public void mouseMoved(MouseEvent e) {
            x = e.getX();
            y = e.getY();
            repaint();  // 공 위치 갱신
        }
        @Override
        public void mouseDragged(MouseEvent e) { }  // 드래그 이벤트는 처리하지 않음
    }
    public FollowMouseApp() {
        setTitle("Follow the Mouse");
        add(new MyPanel());
        setSize(500, 300);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setVisible(true);
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new
                FollowMouseApp());
    }
}