import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;

public class RotatingImageApp extends JFrame {
    // 회전 이미지를 그리는 패널
    private class RotatingImagePanel extends JPanel {
        private Image image;
        private double angle = 0;  // 회전 각도

        public RotatingImagePanel(String imagePath) {
            image = new ImageIcon(imagePath).getImage();
            // 키보드 이벤트 처리
            addKeyListener(new KeyAdapter() {
                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == KeyEvent.VK_LEFT) {
                        angle -= 5;  // 왼쪽 방향키로 반시계 방향 회전
                    } else if (e.getKeyCode() == KeyEvent.VK_RIGHT) {
                        angle += 5;  // 오른쪽 방향키로 시계 방향 회전
                    }
                    repaint();  // 화면 갱신
                }
            });
            setFocusable(true);  // 키보드 포커스 활성화
        }
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D) g;

            // 회전 중심 계산
            int centerX = getWidth() / 2;
            int centerY = getHeight() / 2;

            // AffineTransform 설정
            AffineTransform transform = new AffineTransform();
            transform.rotate(Math.toRadians(angle), centerX, centerY);
            transform.translate(centerX - image.getWidth(this) / 2, centerY - image.getHeight(this) / 2);  // 이미지의 중심을 패널의 중심으로 맞춘다.

            // 변환 적용 및 이미지 렌더링
            g2d.setTransform(transform);
            g2d.drawImage(image, 0, 0, this);

            // 좌표계 초기화
            g2d.setTransform(new AffineTransform());
        }
    }
    public RotatingImageApp() {
        super("Rotating Image");
        RotatingImagePanel panel = new RotatingImagePanel("images/car.png");
        add(panel);
        setSize(500, 300);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setVisible(true);
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new RotatingImageApp());
    }
}
