import javax.swing.*;
import java.awt.*;

public class ImageCropExample extends JFrame {
    private class MyPanel extends JPanel {
        private Image image;

        public MyPanel() {
            image = new ImageIcon("images/car.png").getImage();
        }
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            // 이미지 크기
            int imageWidth = image.getWidth(this);
            int imageHeight = image.getHeight(this);

            // 왼쪽에 원본 이미지 표시
            g.drawImage(image, 50, 50, this);

            // 잘라낼 이미지의 영역 설정
            int cropX = imageWidth / 4;       // 이미지의 가로 1/4 지점
            int cropY = imageHeight / 4;      // 이미지의 세로 1/4 지점
            int cropWidth = imageWidth / 2;   // 가로의 1/2
            int cropHeight = imageHeight / 2;  // 세로의 1/2

            // 원본 이미지 위에 사각형 표시(잘라낸 영역)
            g.setColor(Color.RED);
            g.drawRect(50 + cropX, 50 + cropY, cropWidth, cropHeight);
            // 오른쪽에 잘라낸 이미지 표시
            g.drawImage(image, 300, 50, 300 + cropWidth, 50 + cropHeight, cropX, cropY,
                    cropX + cropWidth, cropY + cropHeight, this);

            g.setColor(Color.BLACK);			// 안내 텍스트 추가
            g.drawString("Original Image", 50, 40);
            g.drawString("Cropped Image", 300, 40);
        }
    }
    public ImageCropExample() {
        add(new MyPanel());
        setSize(800, 200);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setVisible(true);
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new ImageCropExample());
    }
}