import javax.swing.*;
import java.awt.*;

public class DrawImageExample extends JFrame {
    private class MyPanel extends JPanel {
        private Image image;

        public MyPanel() {
            ImageIcon icon = new ImageIcon("images/car.png");
            image= icon.getImage();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);

            // 1. 원본 크기로 이미지 그리기
            // 원본 이미지를 화면의 (0, 0)에 크기 변경 없이 그린다.
            g.drawImage(image, 0, 0, this);
            g.drawString("원본", 50, 120);  // 이미지 아래에 텍스트 추가

            // 2. 다른 크기로 조정하여 이미지 그리기
            // 원본 이미지를 화면의 (300, 0)에서 (500, 200)에 맞추어 그린다.
            g.drawImage(image, 300, 0, 500, 200, this);
            g.drawString("확대", 310, 220);  // 이미지 아래에 텍스트 추가
        }
    }
    public DrawImageExample() {
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setSize(900, 300); // 창 크기 확대
        add(new MyPanel());
        setVisible(true);
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new DrawImageExample());
    }
}