import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

// 사용자 정의 버튼 클래스
class CustomButton extends JButton {
    private boolean isHovered = false;
    private boolean isPressed = false;
    private String text;

    public CustomButton(String text) {
        this.text = text;
        setBorderPainted(false);
        setFocusPainted(false);
        setContentAreaFilled(false);

        // 마우스 이벤트 리스너 추가
        addMouseListener(new MouseAdapter() {
            @Override
            public void mouseEntered(MouseEvent e) {
                isHovered = true;
                repaint();
            }
            @Override
            public void mouseExited(MouseEvent e) {
                isHovered = false;
                repaint();
            }
            @Override
            public void mousePressed(MouseEvent e) {
                isPressed = true;
                repaint();
            }
            @Override
            public void mouseReleased(MouseEvent e) {
                isPressed = false;
                repaint();
            }
        });
    }
    @Override
    protected void paintComponent(Graphics g) {
        // 버튼 배경 색상 설정
        if (isPressed) {
            g.setColor(Color.GREEN);  // 클릭 상태 색상
        } else if (isHovered) {
            g.setColor(Color.MAGENTA);  // 호버 상태 색상
        } else {
            g.setColor(Color.BLUE);  // 기본 색상
        }
        g.fillRoundRect(0, 0, getWidth(), getHeight(), 30, 30);

        // 버튼 텍스트 스타일
        g.setColor(Color.WHITE);
        g.setFont(new Font("Arial", Font.BOLD, 24));
        FontMetrics fm = g.getFontMetrics();
        int textWidth = fm.stringWidth(text);
        int textHeight = fm.getHeight();
        g.drawString(text, (getWidth() - textWidth) / 2, (getHeight() + textHeight / 3) / 2);

        super.paintComponent(g);
    }
}

// 사용자 정의 프레임 클래스
public class CustomButtonFrame extends JFrame {
    public CustomButtonFrame(String title) {
        super(title);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setSize(500, 200);
        setLayout(null);
        setLocationRelativeTo(null);

        // 커스텀 버튼 추가
        CustomButton button = new CustomButton("Click Me!");
        button.setBounds(100, 30, 200, 80);
        add(button);
        setVisible(true);
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new CustomButtonFrame("Custom Button Example"));
    }
}
