import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class MouseDrawingApp extends JFrame {
    private class MyPanel extends JPanel {
        private final ArrayList<Point> points = new ArrayList<>();  // 모든 점을 저장할 리스트
        private boolean isDrawing = false;  // 현재 드로잉 상태

        public MyPanel() {
            // 마우스 이벤트 처리
            addMouseListener(new MouseAdapter() {
                @Override
                public void mousePressed(MouseEvent e) {
                    isDrawing = true;  // 드로잉 시작
                    points.add(e.getPoint());  // 시작 점 저장
                }
                @Override
                public void mouseReleased(MouseEvent e) {
                    isDrawing = false;  // 드로잉 종료
                    points.add(null);  // 선 끊기 표시를 위해 null 추가
                }
            });
            addMouseMotionListener(new MouseAdapter() {
                @Override
                public void mouseDragged(MouseEvent e) {
                    if (isDrawing) {
                        points.add(e.getPoint());  // 드래그 중 점 추가
                        repaint();  // 화면 갱신
                    }
                }
            });
        }
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D) g;
            g2d.setColor(Color.BLUE);  // 선 색상 설정
            g2d.setStroke(new BasicStroke(3));  // 선 두께 설정

            // 저장된 점들로 선 그리기
            Point prev = null;
            for (Point p : points) {
                if (p == null) {
                    prev = null;  // null일 경우 선 끊기
                } else if (prev != null) {
                    g2d.drawLine(prev.x, prev.y, p.x, p.y);  // 두 점을 잇는 선 그리기
                }
                prev = p;
            }
        }
    }
    public MouseDrawingApp() {
        setTitle("Draw with Mouse");  // 프레임 제목
        setSize(500, 300);  // 프레임 크기
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);  // 닫기 동작 설정
        setLocationRelativeTo(null);  // 화면 중앙 배치
        add(new MyPanel());  // MyPanel 추가
        setVisible(true);  // 프레임 표시
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new MouseDrawingApp());  // 애플리케이션 실행
    }
}