import java.awt.*;
import javax.swing.*;

public class DrawImageFrame2 extends JFrame {
    // 이미지를 저장할 변수와 이미지의 초기 위치 설정
    Image img;
    int pos_x = 100, pos_y = 0;  // 이미지의 초기 위치(x: 100, y: 0)

    public DrawImageFrame2() {
        // 이미지 로드
        ImageIcon icon = new ImageIcon("images/car.png");  // 이미지 파일 경로 설정
        img = icon.getImage();  // Image 객체로 변환

        // 프레임 크기 설정
        setSize(500, 200);

        // 이미지 그리기를 처리할 사용자 정의 패널 추가
        add(new MyPanel(), BorderLayout.CENTER);  // MyPanel을 프레임 중앙에 추가

        // 버튼을 포함할 하단 패널 생성
        JPanel panel = new JPanel();
        Button b1 = new Button("왼쪽으로 이동");  // 왼쪽 이동 버튼 생성
        Button b2 = new Button("오른쪽으로 이동");  // 오른쪽 이동 버튼 생성

        // 왼쪽 이동 버튼에 액션 리스너 추가
        b1.addActionListener(e -> {
            pos_x -= 10;  // x 좌표를 10 감소
            repaint();  // 화면을 갱신하여 변경된 위치 반영
        });

        // 오른쪽 이동 버튼에 액션 리스너 추가
        b2.addActionListener(e -> {
            pos_x += 10;  // x 좌표를 10 증가
            repaint();  // 화면을 갱신하여 변경된 위치 반영
        });

        // 버튼들을 하단 패널에 추가
        panel.add(b1);
        panel.add(b2);

        // 하단 패널을 프레임의 남쪽에 추가
        add(panel, BorderLayout.SOUTH);

        // 프레임 보이기 설정
        setVisible(true);

        // 창 닫기 버튼 설정
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

    // 사용자 정의 패널 클래스(이미지 그리기 처리)
    class MyPanel extends JPanel {
        // 컴포넌트 그리기 처리 메서드
        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);  // 부모 클래스의 paintComponent 호출(기본 설정 유지)
            g.drawImage(img, pos_x, pos_y, this);  // 이미지 그리기(현재 위치 pos_x, pos_y 기준)
        }
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new DrawImageFrame2());
    }
}
