import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

// 드래그 앤 드롭 애플리케이션
public class DragAndDropApp extends JFrame {
    // 내부 패널 클래스
    private class MyPanel extends JPanel {
        private int rectX = 100, rectY = 100;  // 사각형 초기 위치
        private int rectWidth = 100, rectHeight = 100;  // 사각형 크기
        private boolean dragging = false;  // 드래그 상태 플래그
        private int offsetX, offsetY;  // 마우스 클릭 지점과 사각형의 거리

        public MyPanel() {
            // 마우스 이벤트 처리
            addMouseListener(new MouseAdapter() {
                @Override
                public void mousePressed(MouseEvent e) {
                    // 마우스가 사각형 내부를 클릭했는지 확인
                    if (e.getX() >= rectX && e.getX() <= rectX + rectWidth && e.getY() >= rectY	&& e.getY() <= rectY + rectHeight) {
                        dragging = true;  // 드래그 시작
                        offsetX = e.getX() - rectX;
                        offsetY = e.getY() - rectY;
                    }
                }
                @Override
                public void mouseReleased(MouseEvent e) {
                    dragging = false;  // 드래그 종료
                }
            });
            addMouseMotionListener(new MouseAdapter() {
                @Override
                public void mouseDragged(MouseEvent e) {
                    if (dragging) {
                        // 드래그 중인 경우 사각형의 위치를 업데이트
                        rectX = e.getX() - offsetX;
                        rectY = e.getY() - offsetY;
                        repaint();  // 화면 갱신
                    }
                }
            });
        }
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            // 배경색
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, getWidth(), getHeight());

            // 사각형 그리기
            g.setColor(Color.BLUE);
            g.fillRect(rectX, rectY, rectWidth, rectHeight);
        }
    }
    public DragAndDropApp() {
        setTitle("Drag and Drop Rectangle");  // 프레임 제목
        setSize(500, 300);  // 프레임 크기
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);  // 닫기 동작
        setLocationRelativeTo(null);  // 화면 중앙에 배치
        add(new MyPanel());  // MyPanel 추가
        setVisible(true);  // 프레임 보이기
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new DragAndDropApp());  // DragAndDropApp 실행
    }
}