import javax.swing.*;
import java.awt.*;

public class BasicPainting extends JFrame {
    private class MyPanel extends JPanel {
        @Override
        protected void paintComponent(Graphics g) {  // paintComponent()를 오버라이딩
            super.paintComponent(g);  // 부모 클래스의 paintComponent() 호출로 기존 배경 처리

            g.drawOval(60, 50, 60, 60);   // 좌표 (60, 50)에 지름 60의 원 그리기
            g.drawRect(120, 50, 60, 60);  // 좌표 (120, 50)에 60×60 크기의 사각형 그리기

            g.setColor(Color.BLUE);      // 그리기 색상을 파란색으로 설정
            g.fillOval(180, 50, 60, 60);    // 좌표 (180, 50)에 채워진 원 그리기
            g.fillRect(240, 50, 60, 60);    // 좌표 (240, 50)에 채워진 사각형 그리기
        }
    }
    public BasicPainting() {
        setTitle("Basic Painting");
        setSize(600, 200);
        add(new MyPanel());
        setVisible(true);
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new BasicPainting());
    }
}