import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class RadioButtonDemo extends JFrame {
    private JLabel imageLabel;  // 이미지를 표시할 라벨

    public RadioButtonDemo() {
        // 프레임 기본 설정
        setTitle("RadioButtonDemo");
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setSize(350, 300);
        setLayout(new BorderLayout());

        // 라디오 버튼 생성
        JRadioButton birdButton = new JRadioButton("Bird");
        JRadioButton catButton = new JRadioButton("Cat");
        JRadioButton dogButton = new JRadioButton("Dog");
        JRadioButton rabbitButton = new JRadioButton("Rabbit");
        JRadioButton pigButton = new JRadioButton("Pig");

        // 버튼 그룹 생성
        ButtonGroup group = new ButtonGroup();
        group.add(birdButton);
        group.add(catButton);
        group.add(dogButton);
        group.add(rabbitButton);
        group.add(pigButton);

        // 라디오 버튼들을 담을 패널 생성
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.Y_AXIS));  // 수직으로 버튼 배치
        buttonPanel.add(birdButton);
        buttonPanel.add(catButton);
        buttonPanel.add(dogButton);
        buttonPanel.add(rabbitButton);
        buttonPanel.add(pigButton);

        // 패널에 여백 추가
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(30, 10, 10, 10));  // 위쪽 여백 20, 나머지 10

        // 이미지 라벨 초기화
        imageLabel = new JLabel();
        imageLabel.setHorizontalAlignment(SwingConstants.CENTER);

        // 기본 이미지를 설정
        ImageIcon defaultImage = new ImageIcon("images/bird.jpg");   // "bird.jpg"는 기본 이미지 경로
        imageLabel.setIcon(defaultImage);

        // 이벤트 처리
        ActionListener listener = e -> {
            if (birdButton.isSelected()) {
                imageLabel.setIcon(new ImageIcon("images/bird.jpg"));   // Bird 이미지 경로
            } else if (catButton.isSelected()) {
                imageLabel.setIcon(new ImageIcon("images/cat.jpg"));    // Cat 이미지 경로
            } else if (dogButton.isSelected()) {
                imageLabel.setIcon(new ImageIcon("images/dog.jpg"));    // Dog 이미지 경로
            } else if (rabbitButton.isSelected()) {
                imageLabel.setIcon(new ImageIcon("images/rabbit.jpg"));  // Rabbit 이미지 경로
            } else if (pigButton.isSelected()) {
                imageLabel.setIcon(new ImageIcon("images/pig.jpg"));     // Pig 이미지 경로
            }
        };

        // 각 라디오 버튼에 이벤트 리스너 추가
        birdButton.addActionListener(listener);
        catButton.addActionListener(listener);
        dogButton.addActionListener(listener);
        rabbitButton.addActionListener(listener);
        pigButton.addActionListener(listener);

        // 프레임에 컴포넌트 추가
        add(buttonPanel, BorderLayout.WEST);    // 버튼 패널을 왼쪽에 배치
        add(imageLabel, BorderLayout.CENTER);  // 이미지를 가운데에 배치
        setVisible(true);
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new RadioButtonDemo());
    }
}