import javax.swing.*;
import java.awt.*;

public class JLabelExample extends JFrame {
    public JLabelExample() {
        setTitle("JLabel 예제");
        setSize(500, 500);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setLayout(new GridLayout(3, 1, 10, 10));  // 행렬 배치로 각 레이블 분리

        // 텍스트만 있는 레이블
        JLabel textLabel = new JLabel("안녕하세요, JLabel!");
        textLabel.setFont(new Font("Gulim", Font.BOLD, 18));  // 폰트 설정
        textLabel.setForeground(Color.BLUE);  // 텍스트 색상 설정
        textLabel.setOpaque(true);  // 배경색 활성화
        textLabel.setBackground(Color.GREEN);  // 배경색 설정
        textLabel.setHorizontalAlignment(SwingConstants.CENTER);  // 수평 중앙 정렬
        textLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));  // 테두리 설정

        // 이미지만 있는 레이블
        ImageIcon imageIcon = new ImageIcon("dog.png");  // 이미지 경로를 지정
        JLabel imageLabel = new JLabel(imageIcon);
        imageLabel.setOpaque(true);  // 배경색 활성화
        imageLabel.setBackground(Color.BLUE);  // 배경색 설정
        imageLabel.setBorder(BorderFactory.createLineBorder(Color.RED, 2));  // 테두리 설정

        // 텍스트와 이미지가 함께 있는 레이블
        JLabel combinedLabel = new JLabel("텍스트와 아이콘", imageIcon, JLabel.CENTER);
        combinedLabel.setFont(new Font("Gulim", Font.ITALIC, 14));  // 폰트 설정
        combinedLabel.setHorizontalTextPosition(SwingConstants.RIGHT);  // 텍스트를 이미지 오른쪽에 배치
        combinedLabel.setVerticalTextPosition(SwingConstants.CENTER);  // 텍스트를 이미지 중앙에 정렬
        combinedLabel.setOpaque(true);  // 배경색 활성화
        combinedLabel.setBackground(Color.YELLOW);  // 배경색 설정
        combinedLabel.setBorder(BorderFactory.createLineBorder(Color.BLUE, 2));  // 테두리 설정

        add(textLabel);
        add(imageLabel);
        add(combinedLabel);
        setVisible(true);
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new JLabelExample());
    }
}