import javax.swing.*;
import java.awt.event.*;

public class MenuTest extends JFrame {
    public MenuTest() {
        // 프레임 기본 설정
        setTitle("메뉴 이벤트 예제");
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setSize(400, 300);

        // 메뉴바 생성
        JMenuBar menuBar = new JMenuBar();

        // 메뉴 생성
        JMenu fileMenu = new JMenu("파일");
        JMenu editMenu = new JMenu("편집");

        // 메뉴 항목 생성
        JMenuItem openItem = new JMenuItem("열기");
        JMenuItem saveItem = new JMenuItem("저장");
        JMenuItem exitItem = new JMenuItem("종료");

        // 메뉴 항목에 이벤트 리스너 추가
        openItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(MenuTest.this, "열기 선택됨");
            }
        });

        saveItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(MenuTest.this, "저장 선택됨");
            }
        });

        exitItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                int response = JOptionPane.showConfirmDialog(
                        MenuTest.this,
                        "정말 종료하시겠습니까?",
                        "종료 확인",
                        JOptionPane.YES_NO_OPTION
                );
                if (response == JOptionPane.YES_OPTION) {
                    System.exit(0);
                }
            }
        });

        // 메뉴에 항목 추가
        fileMenu.add(openItem);
        fileMenu.add(saveItem);
        fileMenu.addSeparator(); // 구분선 추가
        fileMenu.add(exitItem);

        // 메뉴바에 메뉴 추가
        menuBar.add(fileMenu);
        menuBar.add(editMenu);

        // 프레임에 메뉴바 설정
        setJMenuBar(menuBar);
        setVisible(true);
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new MenuTest());
    }
}