import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;

public class SliderImageExample extends JFrame {
    private JSlider slider;
    private JLabel imageLabel;
    private ImageIcon originalIcon;

    public SliderImageExample() {
        setTitle("슬라이더 테스트");
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setSize(600, 600);
        setLayout(null);  // 절대 위치 설정

        // 슬라이더 생성
        slider = new JSlider(50, 300, 100);  // 최솟값 50, 최댓값 300, 초깃값 100
        slider.setBounds(50, 20, 500, 50);    // 슬라이더 위치와 크기 설정
        slider.setMajorTickSpacing(50);       // 주요 눈금 간격
        slider.setMinorTickSpacing(10);       // 부수 눈금 간격
        slider.setPaintTicks(true);            // 눈금 표시
        slider.setPaintLabels(true);           // 값 레이블 표시
        slider.addChangeListener(new SliderChangeListener());
        add(slider);

        // 이미지 로드
        originalIcon = new ImageIcon("images/dog.jpg");  // 이미지 경로 설정
        imageLabel = new JLabel(originalIcon);
        imageLabel.setBounds(150, 100, 300, 300);       // 이미지 초기 위치 설정
        imageLabel.setHorizontalAlignment(SwingConstants.CENTER);
        add(imageLabel);
        setVisible(true);
    }

    // 이미지 크기를 변경하는 리스너
    private class SliderChangeListener implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            int scale = slider.getValue();  // 슬라이더 값 가져오기
            resizeImage(scale);
        }
    }

    // 이미지 크기를 조절하는 메소드
    private void resizeImage(int scale) {
        // 원본 이미지 크기 가져오기
        int originalWidth = originalIcon.getIconWidth();
        int originalHeight = originalIcon.getIconHeight();

        // 새로운 크기 계산
        int newWidth = originalWidth * scale / 100; // 초깃값(100%) 기준으로 계산
        int newHeight = originalHeight * scale / 100;

        // 이미지 크기 변경
        Image scaledImage = originalIcon.getImage().getScaledInstance(newWidth, newHeight, Image.SCALE_SMOOTH);
        imageLabel.setIcon(new ImageIcon(scaledImage));

        // 이미지 중앙 정렬
        imageLabel.setBounds(300 - (newWidth / 2), 150, newWidth, newHeight);
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new SliderImageExample());
    }
}