import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class ComboBoxImageDemo extends JFrame {
    private JComboBox<String> comboBox;
    private JLabel imageLabel;

    // 이미지 경로(이미지는 프로젝트 폴더에 저장해야 함)
    private final String[] imagePaths = {
            "images/dog.jpg",    // Dog 이미지 경로
            "images/bird.jpg",    // Bird 이미지 경로
            "images/cat.jpg",     // Cat 이미지 경로
            "images/rabbit.jpg",  // Rabbit 이미지 경로
            "images/pig.jpg"     // Pig 이미지 경로
    };

    public ComboBoxImageDemo() {
        setTitle("ComboBox Image Demo");
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setSize(400, 300);
        setLayout(new BorderLayout());

        // 콤보 박스 생성
        String[] items = {"Dog", "Bird", "Cat", "Rabbit", "Pig"};
        comboBox = new JComboBox<>(items);
        comboBox.addActionListener(new ComboBoxActionListener());

        // 이미지를 표시할 레이블 생성
        imageLabel = new JLabel();
        imageLabel.setHorizontalAlignment(SwingConstants.CENTER);
        imageLabel.setVerticalAlignment(SwingConstants.CENTER);

        // 초기 이미지 설정
        updateImage(0);

        // 컴포넌트 추가
        add(comboBox, BorderLayout.NORTH);    // 콤보 박스는 상단
        add(imageLabel, BorderLayout.CENTER);  // 이미지는 중앙
        setVisible(true);
    }

    // 콤보 박스 선택 시 호출되는 메소드
    private void updateImage(int index) {
        ImageIcon icon = new ImageIcon(imagePaths[index]);
        imageLabel.setIcon(icon);
    }

    // 콤보 박스 이벤트 리스너
    private class ComboBoxActionListener implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedIndex = comboBox.getSelectedIndex();
            updateImage(selectedIndex);
        }
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new ComboBoxImageDemo());
    }
}