import javax.swing.*;
import javax.swing.border.LineBorder;
import java.awt.*;

public class ComponentTest extends JFrame {
    private JButton button;
    private JLabel label;
    private JCheckBox enableCheckBox;
    private JCheckBox visibleCheckBox;
    private JButton parentButton;

    public ComponentTest() {
        setTitle("스윙 컴포넌트 예제");
        setSize(400, 350);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setLayout(null);
        initComponents();
        setVisible(true);
    }
    private void initComponents() {
        // JButton 생성
        button = new JButton("동적 버튼");
        button.setBounds(50, 50, 150, 50);
        button.setBorder(new LineBorder(Color.BLUE, 2));  // 테두리 설정
        button.setBackground(Color.LIGHT_GRAY);  // 배경색 설정
        button.setForeground(Color.BLACK);  // 전경색 설정
        button.setFont(new Font("Gulim", Font.BOLD, 14));  // 폰트 설정
        button.setCursor(new Cursor(Cursor.HAND_CURSOR));  // 커서 설정
        button.setToolTipText("클릭하면 동작을 확인할 수 있습니다!"); // 툴팁 설정
        add(button);

        // JLabel 생성
        label = new JLabel("버튼 부모 정보:");
        label.setBounds(50, 120, 300, 30);
        add(label);

        // JCheckBox 생성: 버튼 활성화/비활성화
        enableCheckBox = new JCheckBox("버튼 활성화");
        enableCheckBox.setBounds(50, 160, 150, 30);
        enableCheckBox.setSelected(true);
        add(enableCheckBox);

        // JCheckBox 생성: 버튼 표시/숨기기
        visibleCheckBox = new JCheckBox("버튼 표시");
        visibleCheckBox.setBounds(50, 200, 150, 30);
        visibleCheckBox.setSelected(true);
        add(visibleCheckBox);

        // JButton: 부모 컨테이너 정보 확인
        parentButton = new JButton("부모 정보 확인");
        parentButton.setBounds(50, 240, 150, 30);
        add(parentButton);

        // 버튼 동작 정의
        enableCheckBox.addActionListener(e -> button.setEnabled(enableCheckBox.isSelected())); // 버튼 활성화/비활성화
        visibleCheckBox.addActionListener(e -> button.setVisible(visibleCheckBox.isSelected())); // 버튼 표시/숨기기

        parentButton.addActionListener(e -> {
            Container parent = button.getParent();
            if (parent != null) {
                label.setText("버튼 부모: " + parent.getClass().getSimpleName());
            } else {
                label.setText("버튼 부모: 발견되지 않음");
            }
        });
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new ComponentTest());
    }
}