import javax.swing.*;
import java.awt.event.*;

public class KeyInfoDisplay extends JFrame {
    private JLabel label;

    public KeyInfoDisplay() {
        setTitle("Key Info Display");			// 프레임 설정
        setSize(300, 200);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setLayout(null); // 레이아웃을 null로 설정하여 절대 위치 사용

        // 라벨 추가
        label = new JLabel("<html>키를 누르면 정보가 출력됩니다.<br><br></html>", SwingConstants.CENTER);
        label.setBounds(10, 10, 260, 150); // 절대 위치와 크기 설정
        add(label);

        // 익명 클래스를 사용하여 KeyListener 추가
        addKeyListener(new KeyAdapter() {
            @Override
            public void keyPressed(KeyEvent e) {
                // 키 정보 가져오기
                String keyName = KeyEvent.getKeyText(e.getKeyCode());
                int keyCode = e.getKeyCode();
                char keyChar = e.getKeyChar();
                boolean isActionKey = e.isActionKey();

                // 정보 출력
                String info = String.format("<html>키 정보:<br>" + "Key Name: %s<br>" + "Key Code: %d<br>" + "Key Char: %c<br>" + "Is Action Key: %b<br></html>", keyName, keyCode, keyChar, isActionKey);
                label.setText(info);
            }
        });

        setVisible(true);
        setFocusable(true);		// 포커스 가능하게 설정
        requestFocus();
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> 	new KeyInfoDisplay());
    }
}