import java.awt.*; 			// 레이아웃 및 컴포넌트 관련 클래스
import java.awt.event.*; 		// 이벤트 처리 관련 클래스
import javax.swing.*; 		// Swing GUI 컴포넌트 관련 클래스

public class KeyPad extends JFrame implements ActionListener {
    private JTextField txt;  // 숫자를 입력하거나 표시할 텍스트 필드
    private JPanel panel;   // 숫자 버튼들을 배치할 패널

    public KeyPad() {
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        txt = new JTextField(20);        // 텍스트 필드의 길이는 20
        add(txt, BorderLayout.NORTH);  // 텍스트 필드를 프레임의 북쪽(NORTH)에 배치

        // 중앙에 버튼을 배치할 패널 생성 및 레이아웃 설정
        panel = new JPanel();
        panel.setLayout(new GridLayout(3, 3));  // 3×3 그리드 레이아웃
        add(panel, BorderLayout.CENTER);     // 패널을 프레임의 중앙(CENTER)에 배치

        // 1부터 9까지 숫자 버튼 생성 및 패널에 추가
        for (int i = 1; i <= 9; i++) {
            JButton btn = new JButton("" + i); // 숫자를 표시하는 버튼 생성
            btn.addActionListener(this);         // 버튼에 이벤트 리스너 등록
            btn.setPreferredSize(new Dimension(100, 30)); // 버튼 크기 설정
            panel.add(btn); // 버튼을 패널에 추가
        }
        pack(); // 컴포넌트의 크기에 맞게 프레임 크기 조정
        setVisible(true); // 프레임을 화면에 표시
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        // 클릭한 버튼의 텍스트를 가져옴
        String actionCommand = e.getActionCommand();
        // 텍스트 필드에 버튼의 텍스트를 추가
        txt.setText(txt.getText() + actionCommand);
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new KeyPad()); // KeyPad 인스턴스 생성 및 실행
    }
}
