import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class EventObjectExample extends JFrame {
    private JButton button;

    public EventObjectExample() {
        setTitle("Event Object Example");
        setSize(300, 200);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setLayout(new FlowLayout());

        // 버튼 생성 및 이벤트 리스너 추가
        button = new JButton("Click Me!");
        button.addActionListener(new ButtonClickListener());

        add(button);
        setVisible(true);
    }

    // 내부 클래스 형태로 이벤트 리스너 정의
    private class ButtonClickListener implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            // 이벤트를 발생시킨 버튼 가져오기
            JButton sourceButton = (JButton) e.getSource();

            // 버튼 텍스트 토글
            if (sourceButton.getText().equals("Click Me!")) {
                sourceButton.setText("클릭되었음");
            } else {
                sourceButton.setText("Click Me!");
            }
        }
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new EventObjectExample());
    }
}