import javax.swing.*;      // Swing GUI 컴포넌트 임포트
import java.awt.*;         // 레이아웃 및 그래픽 관련 클래스 임포트
import java.awt.event.*;   // 이벤트 처리 관련 클래스 임포트
import java.util.Random;  // 랜덤 숫자 생성을 위한 Random 클래스 임포트

public class MouseColorChanger extends JFrame {
    private final Random random = new Random();  // 랜덤 색상을 생성하기 위한 Random 객체

    public MouseColorChanger() {
        setTitle("클릭으로 색깔 바꾸기");  // 창 제목 설정
        setSize(500, 300);  // 창 크기 설정
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);  // 창 닫기 버튼 동작 설정

        JPanel panel = new JPanel();  // 패널 생성
        panel.addMouseListener(new MouseAdapter() {  // 마우스 이벤트 리스너 등록
            @Override
            public void mouseClicked(MouseEvent e) {
                // 마우스를 클릭할 때 패널의 배경색을 랜덤 색상으로 변경
                panel.setBackground(new Color(
                        random.nextInt(256), // 빨간색 값(0~255)
                        random.nextInt(256), // 초록색 값(0~255)
                        random.nextInt(256)  // 파란색 값(0~255)
                ));
            }
        });
        add(panel);  // 패널을 프레임에 추가
        setVisible(true);  // 프레임을 화면에 표시
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new MouseColorChanger());
    }
}