import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class MouseWheelFontAdjuster extends JFrame {

    private JLabel label;
    private int fontSize = 16;  // 초기 폰트 크기

    public MouseWheelFontAdjuster() {
        setTitle("마우스 휠로 텍스트 크기 조정");
        setSize(400, 200);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        label = new JLabel("마우스 휠로 텍스트 크기를 조정하세요!", SwingConstants.CENTER);
        label.setFont(new Font("Gullim", Font.PLAIN, fontSize));
        add(label);

        addMouseWheelListener(new MouseWheelListener() {
            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int rotation = e.getWheelRotation();
                fontSize += (rotation < 0) ? 1 : -1;  // 휠 위로: 폰트 크기 증가, 아래로: 감소
                fontSize = Math.max(10, fontSize);  // 최소 폰트 크기 제한
                label.setFont(new Font("Gullim", Font.PLAIN, fontSize));
            }
        });
        setVisible(true);
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new MouseWheelFontAdjuster());
    }
}