import java.awt.event.*;   // 이벤트 관련 클래스 임포트
import javax.swing.*;     // Swing GUI 컴포넌트 임포트

public class MoveCar2 extends JFrame {
    int img_x = 150, img_y = 150;   // 이미지(버튼)의 초기 위치
    JButton button;                  // 자동차 이미지를 표시할 버튼

    public MoveCar2() {
        setSize(600, 300);  // 프레임 크기 설정
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);  // 창 닫기 버튼 동작 설정

        button = new JButton("");  // 버튼 생성
        ImageIcon icon = new ImageIcon("car.png");  // 버튼에 사용할 자동차 이미지 아이콘
        button.setIcon(icon); // 버튼에 아이콘 설정

        JPanel panel = new JPanel();  // 패널 생성
        panel.setLayout(null);  // 레이아웃을 null로 설정하여 절대 위치 사용

        button.setLocation(img_x, img_y);  // 버튼의 초기 위치 설정
        button.setSize(200, 100);  // 버튼의 크기 설정
        panel.add(button);  // 패널에 버튼 추가

        // 마우스 이벤트 리스너 추가
        panel.addMouseListener(new MouseListener() {
            // 마우스가 눌렸을 때 실행
            public void mousePressed(MouseEvent e) {
                img_x = e.getX();  // 마우스 X 좌표를 이미지 X 좌표로 설정
                img_y = e.getY();  // 마우스 Y 좌표를 이미지 Y 좌표로 설정
                button.setLocation(img_x, img_y);  // 버튼 위치를 업데이트
            }
            public void mouseReleased(MouseEvent e) { }
            public void mouseEntered(MouseEvent e) { }
            public void mouseExited(MouseEvent e) { }
            public void mouseClicked(MouseEvent e) { }
        });
        add(panel);	        // 패널을 프레임에 추가
        setVisible(true);
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new MoveCar2());  // MoveCar 인스턴스 생성 및 실행
    }
}