import javax.swing.*;
import java.awt.*;

public class Calculator extends JFrame {
    private JPanel panel;            // 버튼을 배치할 패널
    private JTextField tField;        // 결과를 표시할 텍스트 필드
    private JButton[] buttons;        // 버튼 배열
    private String[] labels = {        // 버튼에 표시될 라벨 배열
            "Backspace", "", "", "CE", "C",
            "7", "8", "9", "/", "sqrt",
            "4", "5", "6", "x", "%",
            "1", "2", "3", "-", "1/x",
            "0", "+/-", ".", "+", "=",
    };

    public Calculator() {
        // 텍스트 필드 초기화
        tField = new JTextField(35);  // 텍스트 필드의 너비를 35로 설정
        tField.setText("0.");            // 초기 텍스트를 "0."으로 설정
        tField.setEnabled(false);       // 텍스트 필드를 편집할 수 없도록 설정

        // 패널 초기화 및 레이아웃 설정
        panel = new JPanel();
        panel.setLayout(new GridLayout(0, 5, 3, 3)); // 5열 그리드 레이아웃, 버튼 간격 3

        // 버튼 배열 초기화 및 추가
        buttons = new JButton[25];                 // 25개의 버튼을 위한 배열 생성
        int index = 0;
        for (int rows = 0; rows < 5; rows++) {      // 5행 반복
            for (int cols = 0; cols < 5; cols++) {     // 5열 반복
                buttons[index] = new JButton(labels[index]); // 버튼 생성 및 라벨 설정

                if (cols >= 3)
                    buttons[index].setForeground(Color.red);
                else
                    buttons[index].setForeground(Color.blue);

                // 버튼 배경색을 노란색으로 설정
                buttons[index].setBackground(Color.yellow);

                // 패널에 버튼 추가
                panel.add(buttons[index]);
                index++;  // 다음 버튼 인덱스로 이동
            }
        }

        // 프레임에 컴포넌트 추가
        add(tField, BorderLayout.NORTH);   // 텍스트 필드를 프레임 상단에 추가
        add(panel, BorderLayout.CENTER);  // 패널을 프레임 중앙에 추가

        setVisible(true);  // 프레임을 화면에 표시
        pack();           // 컴포넌트의 크기에 맞게 프레임 크기 조정
    }
    public static void main(String args[]) {
        SwingUtilities.invokeLater(() -> new Calculator());  // 계산기 애플리케이션 실행
    }
}