import java.awt.*;
import javax.swing.*;

public class PizzaOrderApp extends JFrame {
    public PizzaOrderApp() {
        // 프레임 기본 설정
        setSize(600, 150);  // 프레임의 크기를 가로 600, 세로 150으로 설정
        setTitle("PizzaOrderApp");  // 프레임 제목 설정
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);  // 닫기 버튼을 눌렀을 때 프로그램 종료

        JPanel panel = new JPanel();    // 메인 패널 생성
        JPanel panelA = new JPanel();  // 상단 안내문 패널 생성
        JPanel panelB = new JPanel();  // 피자 종류 및 개수 입력 패널 생성

        // panelA: 안내문 라벨 추가
        panelA.add(new JLabel("자바 피자에 오신 것을 환영합니다. 피자의 종류를 선택하시오."));

        // panelB: 피자 종류 버튼과 개수 입력 필드 추가
        panelB.add(new JButton("콤보피자"));      // 콤보피자 버튼 추가
        panelB.add(new JButton("포테이토피자"));  // 포테이토피자 버튼 추가
        panelB.add(new JButton("불고기피자"));    // 불고기피자 버튼 추가

        panelB.add(new JLabel("개수"));  // 개수 입력을 위한 라벨 추가
        panelB.add(new JTextField(10));  // 개수 입력 필드 생성, 너비 10

        // 메인 패널에 panelA와 panelB 추가
        panel.add(panelA);  // panelA를 메인 패널에 추가
        panel.add(panelB);  // panelB를 메인 패널에 추가

        // 메인 패널을 프레임에 추가
        add(panel);
        setVisible(true);  // 프레임을 화면에 표시
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new PizzaOrderApp());  // 애플리케이션 실행
    }
}
