import javax.swing.*;
import java.awt.*;



public class PianoKeys extends JFrame {
    public PianoKeys() {
        setTitle("Piano Key Layout");
        setSize(500, 300);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setLayout(null); // 절대 위치 사용

        JButton[] whiteKeys = new JButton[7];
        JButton[] blackKeys = new JButton[5];


        for (int i = 0; i < whiteKeys.length; i++) {
            whiteKeys[i] = new JButton();
            whiteKeys[i].setBackground(Color.WHITE);
            whiteKeys[i].setBounds(i * (50 + 10), 50, 50, 150);
            add(whiteKeys[i]);
        }

        // 검정 키 만들기(흰 키 사이에 배치)
        for (int i = 0; i < blackKeys.length; i++) {
            blackKeys[i] = new JButton();
            blackKeys[i].setBackground(Color.BLACK);
            int blackKeyX = (i * (50 + 10)) + (3 * 50 / 4); // 흰 키 사이에 위치 조정
            blackKeys[i].setBounds(blackKeyX, 50, 30, 100);
            add(blackKeys[i]);
        }

        setVisible(true);
    }
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new PianoKeys());
    }
}
