interface Shape {
    void draw();

    // 팩토리 메소드
    static Shape create(String type) {
        switch (type) {
            case "circle":
                return new Circle();
            case "rectangle":
                return new Rectangle();
            default:
                throw new IllegalArgumentException("Unknown shape type");  // 예외 발생
        }
    }
}

class Circle implements Shape {
    @Override
    public void draw() {
        System.out.println("원을 그립니다.");
    }
}

class Rectangle implements Shape {
    @Override
    public void draw() {
        System.out.println("사각형을 그립니다.");
    }
}

public class FactoryMethodTest {
    public static void main(String[] args) {
        // 팩토리 메소드를 사용하여 객체 생성
        Shape circle = Shape.create("circle");
        circle.draw();
        Shape rectangle = Shape.create("rectangle");
        rectangle.draw();
    }
}
