interface Vehicle {
    void start();

    // 디폴트 메소드
    default void stop() {
        System.out.println("정지하고 있습니다.");
    }
}

class Bicycle implements Vehicle {
    @Override
    public void start() {
        System.out.println("자전거가 출발하고 있습니다.");
    }
    // Bicycle 클래스는 디폴트 메소드를 그대로 사용
}

class Car implements Vehicle {
    @Override
    public void start() {
        System.out.println("자동차가 출발하고 있습니다.");
    }

    // 필요에 따라 디폴트 메소드를 오버라이딩할 수 있음
    @Override
    public void stop() {
        System.out.println("ABS를 사용하여 정지합니다.");
    }
}

public class DefaultMethodTest {
    public static void main(String[] args) {
        Vehicle car = new Car();
        car.start();
        car.stop();

        Vehicle bicycle = new Bicycle();
        bicycle.start();
        bicycle.stop();
    }
}
