// 추상 클래스 Shape에서 모든 도형이 공통적으로 가지고 있는 면적 계산 메소드를 정의한다.
abstract class Shape {
    public abstract double calculateArea();	 // 추상 메소드: 도형의 면적 계산
}

// 원을 나타내는 클래스 Circle
class Circle extends Shape {
    private double radius;         // 원의 반지름
    public Circle(double radius) {  // 생성자
        this.radius = radius;
    }
    @Override
    public double calculateArea() {   // 면적 계산 메소드 구현
        return Math.PI * radius * radius;
    }
}

// 직사각형을 나타내는 클래스 Rectangle
class Rectangle extends Shape {
    private double width, height;	   // 직사각형의 너비와 높이

    public Rectangle(double width, double height) {  // 생성자
        this.width = width;
        this.height = height;
    }
    @Override
    public double calculateArea() {   // 면적 계산 메소드 구현
        return width * height;
    }
}

public class AbstractTest1 {
    public static void main(String[] args) {
        // Shape 타입의 변수에 Circle 객체를 생성하여 저장
        Shape circle = new Circle(5);  // 반지름이 5인 원
        System.out.println("원의 면적: " + circle.calculateArea());  // 78.5398...

        // Shape 타입의 변수에 Rectangle 객체를 생성하여 저장
        Shape rectangle = new Rectangle(4, 6);  // 너비 4, 높이 6인 직사각형
        System.out.println("사각형의 면적: " + rectangle.calculateArea());  // 24.0
    }
}