// 부모 클래스
class Animal {
    public void speak() {
        System.out.println("동물이 소리를 냅니다.");
    }
    public void sleep() { System.out.println("동물이 잠을 잡니다."); }
    public void eat() { System.out.println("동물이 먹습니다."); }
    public void walk() { System.out.println("동물이 걷습니다."); }
}

// 자식 클래스: Dog
class Dog extends Animal {
    @Override
    public void speak() {
        System.out.println("멍멍");
    }
}

// 자식 클래스: Cat
class Cat extends Animal {
    @Override
    public void speak() {
        System.out.println("야옹");
    }
}

// 자식 클래스: Duck
class Duck extends Animal {
    @Override
    public void speak() {
        System.out.println("꽥꽥");
    }
}

// 메인 클래스
public class OverridingTest  {
    public static void main(String[] args) {
        Dog myDog = new Dog();
        Cat myCat = new Cat();
        Duck myDuck = new Duck();

        myDog.speak(); // "멍멍" 출력
        myCat.speak(); // "야옹" 출력
        myDuck.speak(); // "꽥꽥" 출력
    }
}
