class Vehicle {
    private int speed;     // 속도
    private int direction;  // 방향

    public void setSpeed(int speed) {  // 속도 변경 메소드
        this.speed = speed;
    }
    public void turn(int angle) {      // 방향 변경 메소드
        this.direction = angle;
    }
}

class Truck extends Vehicle {	  // ①
    int currentLoad;             // 현재 적재 중량

    void loadCargo(int weight) {  // 화물을 적재하는 메소드
        setSpeed(0);		       // 화물을 적재할 때는 속도를 0으로 설정
        currentLoad += weight;
    }
    void unloadCargo(int weight) { // 화물을 하역하는 메소드
        setSpeed(0);		        // 화물을 하역할 때는 속도를 0으로 설정
        currentLoad -= weight;
    }
}

public class TruckTest {
    public static void main(String[] args) {
        Truck t = new Truck();   // ②

        t.setSpeed(60);   // ③
        t.turn(180);

        t.loadCargo(10);  // ④
        t.unloadCargo(10);
    }
}