class Character {
    // 속성(멤버 변수)
    String name;
    int health;
    int attackPower;
    int defense;

    // 생성자
    public Character(String name, int health, int attackPower, int defense) {
        this.name = name;
        this.health = health;
        this.attackPower = attackPower;
        this.defense = defense;
    }

    // 메소드(멤버 함수)
    public void attack(Character target) {
        int damage = this.attackPower - target.defense;
        if (damage > 0) {
            target.health -= damage;
            System.out.println(this.name + "가 " + target.name + "을(를) 공격하여 " + damage + "의 피해를 입혔습니다.");
        } else {
            System.out.println(this.name + "가 " + target.name + "을(를) 공격했지만 효과가 없었습니다.");
        }
    }

    public void defend() {
        this.defense += 5;
        System.out.println(this.name + "가 방어 중입니다. 방어력이 " + this.defense + " 증가했습니다.");
    }
}

public class GameTest {
    public static void main(String[] args) {
        Character warrior = new Character("전사", 100, 20, 10);  // 객체 생성
        Character mage = new Character("마법사", 80, 25, 5);

        warrior.attack(mage);  // 메소드 호출
        mage.defend();
        mage.attack(warrior);
    }
}